classdef StateSpaceModel < matlab.mixin.Copyable & matlab.mixin.SetGetExactNames % SetGetExactNames is not supported in MATLAB2015
% STATESPACEMODEL A class for state space models defined by ODEs.
%
% Properties:
%    x      states                             DynamicElement struct
%    a      auxiliary states                   DynamicElement struct
%    d      disturbances (uncontrolled inputs) DynamicElement struct
%    p      parameters                         DynamicElement struct
%    u      controls                           DynamicElement struct
%    c      constraints                        DynamicElement struct
%    g      goal                               string
%    t 		timespan                           DynamicElement
%
% See readme for full details

% David Katzin, Wageningen University
% david.katzin@wur.nl
    
    properties
        x           % states                             DynamicElement struct
        a           % auxiliary states                   DynamicElement struct
        d           % disturbances (uncontrolled inputs) DynamicElement struct
        p           % parameters                         DynamicElement struct
        u           % controls                           DynamicElement struct
		c           % constraints                        DynamicElement struct
        g           % goal                               string
        t 			% timespan                           DynamicElement

    end

    methods
        function m = StateSpaceModel(ssm)
        %STATESPACEMODEL constructor for StateSpaceModel
        % If no argument is given, creates an empty StateSpaceModel object
        % if a StateSpaceModel is given, creates a copy of the argument
            m.t = DynamicElement();
            if nargin == 1 && isa(ssm, 'StateSpaceModel')
               m = copySsm(ssm); 
            end
        end
    end
end

